#! /bin/sh
#
# Copyright  (C) 1985-2016 Intel Corporation. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of Intel Corporation and may not be disclosed, examined, or reproduced in
# whole or in part without explicit written authorization from the Company.
#

INTEL_INSTALL_DIR_ORIG=$INSTALL_DIR
INTEL_NDK_DIR_ORIG=$NDK_DIR
INSTALL_DIR="<INSTALLDIR>"
NDK_DIR="<NDK_DIR>"
NDK_ARCH=''

if [ $# -eq 0 ]; then
	INTEL_TARGET_ARCH=$COMPILERVARS_ARCHITECTURE
	INTEL_TARGET_PLATFORM=$COMPILERVARS_PLATFORM
else
	INTEL_TARGET_ARCH=$1
	INTEL_TARGET_PLATFORM=$2
fi

if [ -z "${PATH}" ] ; then      	
	PATH="$INSTALL_DIR/bin/$INTEL_TARGET_ARCH"; 
else
	PATH="$INSTALL_DIR/bin/$INTEL_TARGET_ARCH:${PATH}"
fi
if [ $INTEL_TARGET_ARCH = "ia32" ]
then
	NDK_ARCH=x86 
	if [ -d "$INSTALL_DIR/mpirt/bin/ia32_lin" ] ; then
		PATH="$INSTALL_DIR/mpirt/bin/ia32_lin:${PATH}"
	fi
elif [ $INTEL_TARGET_ARCH = "intel64" ]
then
	NDK_ARCH=x86_64 
fi
export PATH

if [ "$INTEL_TARGET_PLATFORM" = "android" ] ; then
	export ICCCFG="$INSTALL_DIR/bin/intel64/icc_and.cfg"
	export ICPCCFG="$INSTALL_DIR/bin/intel64/icpc_and.cfg"
	export XIARCFG="$INSTALL_DIR/bin/intel64/xiar_and.cfg"
	export XILDCFG="$INSTALL_DIR/bin/intel64/xild_and.cfg"
else 
	unset ICCCFG
	unset ICPCCFG
	unset XIARCFG
	unset XILDCFG
fi

for a in 9 10 11 12 13 14 15 16 17 18 19 21 L ; do
	if [ -d "${NDK_DIR}/platforms/android-$a/arch-$NDK_ARCH" ] ; then
		ANDROID_SYSROOT="${NDK_DIR}/platforms/android-$a/arch-$NDK_ARCH"
		export ANDROID_SYSROOT
		break;
	fi
done

for g in 4.6 4.8 4.9 ; do
	for h in linux-x86 linux-x86_64 ; do
		if [ -d "${NDK_DIR}/toolchains/$NDK_ARCH-$g/prebuilt/$h" ] ; then
			ANDROID_GNU_X86_TOOLCHAIN="${NDK_DIR}/toolchains/$NDK_ARCH-$g/prebuilt/$h"
			export ANDROID_GNU_X86_TOOLCHAIN
			break;
		fi
	done
done

if [ "`uname`" = "Darwin" ]; then
	# DYLD_LIBRARY_PATH is used on OS X*
	if [ -z "${DYLD_LIBRARY_PATH}" ]
	then
		DYLD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/$INTEL_TARGET_ARCH"; export DYLD_LIBRARY_PATH
	else
		DYLD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/$INTEL_TARGET_ARCH:${DYLD_LIBRARY_PATH}"; export DYLD_LIBRARY_PATH
	fi
	if [ -z "${NLSPATH}" ] 
	then
		NLSPATH="$INSTALL_DIR/compiler/lib/locale/en_US/%N"; export NLSPATH
	else
		NLSPATH="$INSTALL_DIR/compiler/lib/locale/en_US/%N:${NLSPATH}"; export NLSPATH
	fi
	if [ -z "${INTEL_LICENSE_FILE}" ]
	then
		INTEL_LICENSE_FILE="$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses"; export INTEL_LICENSE_FILE 
	else
		INTEL_LICENSE_FILE="${INTEL_LICENSE_FILE}:$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses"; export INTEL_LICENSE_FILE
	fi
	if [ -z "${MANPATH}" ]
	then
		if [ -f "/usr/bin/manpath" ]
	then	
		MANPATH="$INSTALL_DIR/../../man/common":$(manpath):; export MANPATH
	else
		MANPATH="$INSTALL_DIR/../../man/common:"; export MANPATH
	fi
	fi
else
	if [ -d "$INSTALL_DIR/compiler/lib/mic" ] ; then
		if [ -z "${MIC_LD_LIBRARY_PATH}" ] ; then
			MIC_LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/mic"
		else
			MIC_LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/mic:${MIC_LD_LIBRARY_PATH}"
		fi
		export MIC_LD_LIBRARY_PATH

		if [ -z "${MIC_LIBRARY_PATH}" ] ; then
			MIC_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/mic"
		else
			MIC_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/mic:${MIC_LIBRARY_PATH}"
		fi
		export MIC_LIBRARY_PATH
	fi
	if [ -d "$INSTALL_DIR/mpi/mic/lib" ] ; then
		if [ -z "${MIC_LD_LIBRARY_PATH}" ] ; then
			MIC_LD_LIBRARY_PATH="$INSTALL_DIR/mpi/mic/lib"
		else
			MIC_LD_LIBRARY_PATH="$INSTALL_DIR/mpi/mic/lib:${MIC_LD_LIBRARY_PATH}"
		fi
		export MIC_LD_LIBRARY_PATH

		if [ -z "${MIC_LIBRARY_PATH}" ] ; then
			MIC_LIBRARY_PATH="$INSTALL_DIR/mpi/mic/lib"
		else
			MIC_LIBRARY_PATH="$INSTALL_DIR/mpi/mic/lib:${MIC_LIBRARY_PATH}"
		fi
		export MIC_LIBRARY_PATH
	fi

	if [ -z "${LD_LIBRARY_PATH}" ]
	then
		LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/$INTEL_TARGET_ARCH:$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}_lin"
	else
		LD_LIBRARY_PATH="$INSTALL_DIR/compiler/lib/$INTEL_TARGET_ARCH:$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}_lin:${LD_LIBRARY_PATH}"
	fi
	if [ $INTEL_TARGET_ARCH = "ia32" -a -d  "$INSTALL_DIR/mpirt/lib/ia32_lin" ]
	then
		LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$INSTALL_DIR/mpirt/lib/ia32_lin"
	fi
	export LD_LIBRARY_PATH
	if [ -z "${NLSPATH}" ] 
	then
		NLSPATH="$INSTALL_DIR/compiler/lib/$INTEL_TARGET_ARCH/locale/%l_%t/%N"; export NLSPATH 
	else
		NLSPATH="$INSTALL_DIR/compiler/lib/$INTEL_TARGET_ARCH/locale/%l_%t/%N:${NLSPATH}"; export NLSPATH
	fi
	if [ -z "${INTEL_LICENSE_FILE}" ]
	then
		INTEL_LICENSE_FILE="$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses"; export INTEL_LICENSE_FILE 
	else
		INTEL_LICENSE_FILE="${INTEL_LICENSE_FILE}:$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses"; export INTEL_LICENSE_FILE
	fi
	if [ -z "${MANPATH}" -a -d "$INSTALL_DIR/../../man/common" ]
	then
		if [ -f "/usr/bin/manpath" ]
		then	
			MANPATH=`cd $INSTALL_DIR/../../man/common && pwd`:`manpath`; export MANPATH
		else
			MANPATH=`cd $INSTALL_DIR/../../man/common && pwd`; export MANPATH
		fi
        elif [ -d "$INSTALL_DIR/../../man/common" ]
        then
		MANPATH=`cd $INSTALL_DIR/../../man/common && pwd`:"$MANPATH"; export MANPATH
	fi
fi

if [ -n "${INTEL_INSTALL_DIR_ORIG}" ]
then
	INSTALL_DIR=${INTEL_INSTALL_DIR_ORIG}
else
	unset INSTALL_DIR
fi
if [ -n "${INTEL_NDK_DIR_ORIG}" ]
then
	NDK_DIR=${INTEL_NDK_DIR_ORIG}
else
	unset NDK_DIR
fi
unset INTEL_INSTALL_DIR_ORIG
unset INTEL_NDK_DIR_ORIG

